/*
    Mini DSO with STC MCU

    GitHub: https://github.com/CreativeLau/Mini-DSO
    
    Copyright (c) 2020 Creative Lau (creativelaulab@gmail.com)

    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included in all
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
    SOFTWARE.

     
    Version: V0.3
    MCU Type: STC8A8K64S4A12 @27MHz
    YouTube Tutorial(First Version): https://youtu.be/c6gBv6Jcz7w
    YouTube Tutorial(V0.3): https://youtu.be/-8PadlS7c4c
    Instructable(First Version): https://www.instructables.com/id/Make-Your-Own-OscilloscopeMini-DSO-With-STC-MCU-Ea/
    Instructable(V0.3): 
    Any question please contact CreativeLauLab@gmail.com
    YouTube Channel: https://www.youtube.com/c/CreativeLau

    Note:
    How to Operation:
        Main Interface - Parameter Mode:
            Single Click Encoder: Run/Stop sampling
            Double Click Encoder: Enter Wave Scroll Mode
            Long Press Encoder: Enter Settings Interface
            Rotate Encoder: Adjust parameters
            Rotate Encoder While Pressing: Switch between options
            
        Main Interface - Wave Scroll Mode: 
            Single Click Encoder: Run/Stop sampling
            Double Click Encoder: Enter Parameter Mode
            Long Press Encoder: Enter Settings Interface
            Rotate Encoder: Scroll waveform horizontally (only available when sampling stopped)
            Rotate Encoder While Pressing: Scroll waveform vertically (only available when sampling stopped)
            
        Settings Interface:
            Single Click Encoder: N/A
            Double Click Encoder: N/A
            Long Press Encoder: Return to Main Interface
            Rotate Encoder: Adjust parameters
            Rotate Encoder While Pressing: Switch between options

    Parameters in Main Interface:
        Seconds Per Division: "500ms", "200ms", "100ms", "50ms", "20ms", "10ms","5ms", "2ms", "1ms", "500us", "200us", "100us"(100us only available in Auto Trigger Mode)
        Voltage Range: Maximum voltage is 30V. Rotate Encoder clockwise continuous to enter auto range. Rotate Encoder anticlockwise to enter manual range. 
        Trigger Level: Set trigger voltage level. The trigger position will be put at the center of chart. 
                       You should set a correct Trigger Level in Single and Normal Trigger Mode in order to capture the waveform.
        Trigger Slope: Trigger on Rising or Falling Edge. 
                       You should set a correct Trigger Slop in Single and Normal Trigger Mode in order to capture the waveform.
        Trigger Mode:
            Auto:   Sweep continuous, indicator always on. Single click the encoder to stop or run sampling. 
                    If triggered, the waveform will be shown on the display and the trigger position will be put at the center of chart. 
                    Otherwise, the waveform will scroll irregular, and 'Fail' will be shown on the display.
            Normal: When complete pre-sampling, you can input signal. If triggered, waveform shown on the display and waiting for new trigger. 
                    If no new trigger, the waveform will be kept.
            Single: When complete pre-sampling, you can input signal. If triggered, waveform shown on display and stop sampling. 
                    User need to single click Encoder to start next sampling.
            For Normal Mode and Single Mode, be sure the trigger level has been adjusted correctly, otherwise no waveform will be shown on the display.

    Status in Main Interface:
        'Run': Sampling Running.
        'Stop': Sampling Stopped.
        'Fail': The Trigger Level beyond the waveform in Auto Trigger Mode.
        'Auto': Auto Voltage Range.
                    
    Parameters in Settings Interface:
        PMode(Plot Mode): Show waveform in Vector or Dots.
        LSB(Sampling Coefficient): 100 times of voltage dividing coefficient. e.g. the resistor for voltage dividing is 10k and 2k, calculate the voltage dividing coefficient (10+2)/2=6. Get the LSB=6x100=600.
        BRT(Brightness): Adjust OLED Brightness

    Saving Settings: When exit settings interface, all parameters in settings and main interface will be saved in EEPROM.

    Indicator:
    Generally, the indicator on means the sampling is running. 
    The more important use is in Single and Normal Trigger Mode, before get into the trigger stage, pre-sampling is required. 
    The indicator will not on during pre-sampling stage. We should not input signal until the indicator comes on. 
    The longer time scale selected, the longer waiting time of pre-sampling.

    2020-04-30 Update
    1. Add Single Sweep and Normal Sweep function. Set trigger value to catch the waveform mutation.
    2. According to datasheet, set ADC port to high-impedance.

    2020-05-3 Update
    1. Show frequency of waveform.
    2. Scroll waveform horizontally/vertically with EC11 Encoder.
    3. Zoom waveform vertically with EC11 Encoder.
    4. The trigger level could be customized.

    ʾ
    汾V0.3
    ߣ
    ƬͣSTC8A8K64D4 @27MHz
    κϵCreativeLauLab@gmail.com
    ģȫͬڴĹע
    Bվ̳̣棩https://www.bilibili.com/video/BV1ai4y1t79R
    Bվ̳̣V0.3https://www.bilibili.com/video/BV1ai4y1t79R
    ͹Ƶ: https://www.youtube.com/c/CreativeLau

    ˵
        -ѡģʽ
            лʼ/ͣ
            ˫лˮƽģʽ/ѡģʽ
            ý
            ת޸ĵǰ
            ͬʱתڲл
            
        -ˮƽģʽ
            лʼ/ͣ
            ˫лˮƽģʽ/ѡģʽ
            ý
            תˮƽΣͣ״̬Ч
            ͬʱתֱΣͣ״̬Ч
            
        ý棺
            Ч
            ˫Ч
            
            ת޸ĵǰѡ
            ͬʱתлѡ

    
        ʱ䣺"500ms", "200ms", "100ms", "50ms", "20ms", "10ms","5ms", "2ms", "1ms", "500us", "200us", "100us"(100usԶģʽ¿)
        ѹ䣺趨ѹޣ30V˳ʱתѹΪ0Զ̣ʱתֶ
        ֵ趨ѹֵλñĻ
        ¼ͷֱش½ش
        ʽ
            Auto(Զ)  ָʾʼյͨͣɹʱλĻģʧ޹ɹĻʾFail־
            Normal(ͨ)ȴԤָʾʾԤʱźţ
                              ɹʾΣȴ´δ
                              µĴɹԶʾµĲΣûµĴɹĻαֲһֱȴ´δ
                              עȷĴֵһֱڵȴ״̬Ļʾ
            Single(δ)ȴԤָʾʾԤʱźţ
                              ɹʾΣֹͣûʼ´β	
                              עȷĴֵһֱڵȴ״̬Ļʾ
            
    ״̬ʾ	
        Runڲ
        Stopֹͣ
        FailԶģʽ£ֵηΧ𴥷ʧ
        AutoԶ
            
    ýѡ
        PMode(ͼģʽ)
            Vectorʸʾ
            Dots  Եʾ
        LSB(ϵ)ѹϵ10010k2kĵзѹѹϵΪ(10+2/2)=6LSBȡֵΪ6x100=600ʵʵ辫Ƚ΢	
        BRTOLED

    ã˳ýʱýв浽EEPROM

    2020-04-30
    1. ӵδͨܣԶ崥׽α仯
    2. չҪADC˿Ϊ
    2020-5-3
    1. ӲƵʾ
    2. ʹñˮƽ/ֱ
    3. ʹñֱŲ
    4. û趨ƽ
    2022-7-13
    1. Ƭͺ޸Ϊ "STC32G12K128"ĬƵ 35MHz
    2. "config_stc.h"޸ʾʽΪSTC-ISPԽӿOLEDʾӲOLEDʾ
    3. ޸EEPROMʳ
    4. ޸İܣP3.2ڰ̰ʱᣬֹͣ/ɼP3.3ڰ̰ʱᣬʾ/˳ò˵
    5. ʹõԽӿڵOLEDʾͨP3.2ڰOLED-128*64Ļʾ
    6. ӲOLEDʹI2Cӿͨ
    Ҫڳʹô˴,ڳעʹSTCϼ
*/

#include "stc32g.h"
#include "global.h"
#include "delay.h"
#include "adc_stc.h"
#include "config_stc.h"
#include "settings.h"
#include "chart.h"
#include "ssd1306.h"
#include "stc.h"
#include "usb.h"

#define Timer1_Reload   (65536UL -(MAIN_Fosc / 1000))       //Timer 1 жƵ, 1000/

//USBԼλ趨
char *USER_DEVICEDESC = NULL;
char *USER_PRODUCTDESC = NULL;
char *USER_STCISPCMD = "@STCISP#";                      //ԶλISPûӿ

#define VBAT_UPDATE_FREQ 40 //صѹϢĸƵ VBAT_UPDATE_FREQ*25ms
#define VBAT_LSB 200        //صѹѹϵ*100
#define INT_0 0             //ⲿж0ţת
#define INT_1 2             //ⲿж1ţ
#define TIMER_0 1           //ʱ0ж

#define KEY_TIMER 30        //ʱ(ms)

sbit KEY1 = P3 ^ 2;
sbit KEY2 = P3 ^ 3;

uint16 Key1_cnt;
uint16 Key2_cnt;
bit Key1_Flag;
bit Key2_Flag;
bit Key1_Short_Flag;
bit Key2_Short_Flag;

bit oled_init_flag;

bit PWM1_Flag;
uint16 PWM1_Duty;

void KeyScan(void);

void init()
{
    InSettings = 0;         //ʼ
    OptionInSettings = 0;   //ʼýѡ
    OptionInChart = 0;      //ʼѡ
    WaveScroll = 0;         //㲨ι־
    OptionChanged = 0;      //޸ı־
    ADCRunning = 1;         //λ־
    ADCInterrupt = 0;       //ADCжϱ־
    ADCComplete = 0;        //ADCɱ־
    WaveUpdate = 0;         //㲨θ±־
    ClearWave = 0;          //α־
    ClearDisplay = 1;       //λĻ־
    EC11PressAndRotate = 0; //ת־
    UpdateVbat = 0;         //صѹ־
    ADCComplete = 0;        //ADCɲ־
    WaveFreq = 0;           //㲨Ƶ
    TriPos = 50;            //ʼλ
    TriPosOffset = 0;       //ʼƫ
    TriFail = 0;            //㴥ʧܱ־
    VMax = 0;               //㲨εѹֵ
    VMin = 0;               //㲨εѹСֵ
    WaveLengthSumNum = 0;   //㲨γʹ
    WaveLengthSum = 0;      //㲨γ

    /* ȡڲοѹֵ
       Get internal reference voltage */
    BGV = GetBGV();
}

void runWhenInSettrings()
{
    P_Ready = 0;
    ClearDisplay = 1;
    while (InSettings)
    {
        /* µصѹϢ
           Update voltage infor of battery */
        if (UpdateVbat)
        {
            UpdateVbat = 0;
            VBat = GetVoltage(ADC_BAT, VBAT_LSB);
        }

        /* Ļ
           Update OLED Brightness */
        if (OLED_BrightnessChanged)
        {
            OLED_BrightnessChanged = 0;
            
#if(VirtualDevice)
            OLED12864_SetContrast(OLED_Brightness * 10);    //ֵΧ0255
#else
            OLED_Write_Command(0x81);
            OLED_Write_Command(OLED_Brightness * 10);
#endif
        }

        /* ²
           Update parameters */
        if (DisplayUpdate)
        {
            DisplayUpdate = 0;
            PlotSettings();
            OLED_Display();
        }
    }

    /* 
       Save Settings */
//    EA = 0;
    if (OptionChanged)
    {
        OptionChanged = 0;
        ClearDisplay = 0;
        /* òʾ״̬
           Save settings and display saving status*/
        PlotSaveStatus(Save_Options());
        OLED_Display();
        delay_ms(500);
    }

    /* ˳settingsˢĻ
       Redraw display after exit settings */
    ClearDisplay = 1;
    PlotChart();
    OLED_Display();
//    EA = 1;
}

/*
    ADCRuning=1
    |	WaveUpdate=1
    |	|	ClearWave=1
    |	|	ClearWave=0
    |	WaveUpdate=0
    ADCRuning=0
        DisplayUpdate=1
            WaveUpdate=1
            |	ClearWave=1
            |	ClearWave=0
            WaveUpdate=0
*/
void runWhenADCInterrupt()
{
    ADCInterrupt = 0;
    P_Ready = 0;

    /* ADC
       ADC Sampling Running */
    if (ADCRunning)
    {
        if (WaveUpdate)
        {
            WaveUpdate = 0;
            ClearDisplay = 1;

            /* ղλ
               Clear waveform in buffer*/
            if (ClearWave)
            {
                ClearWave = 0;
                memset(ADCbuf, 0x00, SAMPLE_NUM * 2);
                WaveFreq = 0;
                TriFail = 0;
                VMax = 0;
                VMin = 0;
                PlotChart();
            }
            /* ʾеĲ
               Display waveform in buffer*/
            else
            {
                AnalyseData();
                PlotChart();
                PlotWave();
            }
        }
        else
        {
            ClearDisplay = 0;
            PlotChart();
        }
        OLED_Display();
    }

    /* ADCֹͣ
       ADC Sampling Stopped */
    else
    {
        while (!ADCRunning && !InSettings)
        {
            if (DisplayUpdate)
            {
                DisplayUpdate = 0;
                if (WaveUpdate)
                {
                    WaveUpdate = 0;
                    /* ɲĲ
                       Analyse completed sampling data in buffer */
                    AnalyseData();
                    ClearDisplay = 1;

                    /* ĻƲ
                       Clear display and draw waveform */
                    if (ScaleH == ScaleH_tmp)
                    {
                        /* ޣֺ֧ŲΣֻʱɲʱͬŻƲ
                           Since the sampling points limitation, scaling waveform along horizontal is not support.
                           Show waveform only when time scale is same as that when sampling completed */
                        PlotChart();
                        PlotWave();
                    }

                    /* ĻƲ
                       Clear display and no waveform */
                    else
                    {
                        WaveFreq = 0; //WaveFreqƽʱƵλûʾ****Hz
                        PlotChart();
                    }
                }
                /* ֻĻϵĲβ
                   Update parameters on display only, keep waveform */
                else
                {
                    ClearDisplay = 0;
                    PlotChart();
                }

                OLED_Display();
            }
        }
    }
}

void runWhenADCComplete()
{
    /*  ADC - δ
        ADC Sampling Complete - Single Trigger Mode */
    if (TriMode == 2)
    {
        ADCInterrupt = 1;
        DisplayUpdate = 0;
        WaveUpdate = 0;
        ADCRunning = 0; //ADCб־ֹͣ
        AnalyseData();
        ClearDisplay = 1;
        PlotChart();
        PlotWave();
        OLED_Display();
    }

    /*  ADC - Զͨ
        ADC Sampling Complete - Auto or Normal Trigger Mode */
    else
    {
        ClearDisplay = 1; //λĻ־
        AnalyseData();    //
        PlotChart();      //
        PlotWave();       //Ʋ
        OLED_Display();
    }
}

void Timer0Init(void)		//25@1MHz
{
    TM0PS = 34;     //35Ƶ
	AUXR |= 0x80;	//ʱʱ1Tģʽ
	TMOD &= 0xF0;	//öʱģʽ
	TL0 = 0x58;		//öʱʼֵ
	TH0 = 0x9E;		//öʱʼֵ
	TF0 = 0;		//TF0־
//	TR0 = 1;		//ʱ0ʼʱ
    ET0 = 1;        //ʱ0ж
}

void Timer1Init(void)		//1
{
	AUXR |= 0x40;	//ʱʱ1Tģʽ
	TMOD &= 0x0F;	//öʱģʽ
	TH1 = (uint8)(Timer1_Reload / 256);	//öʱʼֵ
	TL1 = (uint8)(Timer1_Reload % 256);	//öʱʼֵ
	TF1 = 0;		//TF1־
    ET1 = 1;		//ж
	TR1 = 1;		//ʱ1ʼʱ
}

void PWMInit(void)
{
    PWMA_CCER1 = 0x00; //д CCMRx ǰ CCxE رͨ
    PWMA_CCMR1 = 0x68; //ͨģʽãCCRԤװع
    PWMA_CCER1 = 0x05; //ͨʹܺͼ

    PWMA_ARRH = 0x00;  //ʱ
    PWMA_ARRL = 0x0f;
    PWMA_CCR1H = 0;
    PWMA_CCR1L = 0;    //ռձʱ

    PWMA_ENO = 0x01;   //PWM1Pʹ
    PWMA_PS = 0x00;    //߼ PWM ͨѡλ

    PWMA_BKR = 0x80;   //ʹ
    PWMA_CR1 |= 0x81;  //ARRԤװػ壬ʼʱ
}

void UpdatePwm(void)
{
    PWMA_CCR1H = (u8)(PWM1_Duty >> 8); //ռձʱ
    PWMA_CCR1L = (u8)(PWM1_Duty);
}

/* 
   Program Entry */
void main()
{
    WTST = 0;  //óָʱֵΪ0ɽCPUִָٶΪ
    EAXFR = 1; //չĴ(XFR)ʹ
    CKCON = 0; //߷XRAMٶ
    
    /* ADC˿P0.4P0.6Ϊ
       Set ADC port P0.4, P0.6 as high-impedance */
//    P0M1 |= 0x50;
//    P0M0 &= ~0x50;

    P0M1 = 0x00;
    P0M0 = 0x03;

    /* ö˿P1Ϊ׼˫
       Set port P1 as quasi bidirectional */
//    P1M1 &= ~0x02;
//    P1M0 |= 0x02;
    P1M1 = 0x18;
    P1M0 = 0x00;

    /* OLED˿P2.3P2.4P2.5P2.6P2.7Ϊ׼˫
       Set OLED port P2.3, P2.4, P2.5, P2.6 as quasi bidirectional */
//    P2M1 &= ~0xF8;
//    P2M0 &= ~0xF8;
    P2M1 = 0x00;
    P2M0 = 0x00;

    /* ñ˿P3.2P3.3P3.4Ϊ׼˫
       Set Encoder port P3.2, P3.3, P3.4 as quasi bidirectional */
//    P3M1 &= ~0x1C;
//    P3M0 &= ~0x1C;
    P3M1 = 0x00;
    P3M0 = 0x00;

    /* ָʾƶ˿P4Ϊ׼˫
       Set indicator port P4 as quasi bidirectional */
    P4M1 = 0x00;
    P4M0 = 0x00;

    P7M1 = 0x00;
    P7M0 = 0x00;

    PWM1_Flag = 0;
    PWM1_Duty = 0;
    
    ADC_POWER = 1;       //ʹ ADC ģ
    PWMInit();
    Timer0Init();
    Timer1Init();

    IAP_TPS = 35; //EEPROMʱ 35MHz/1000000
    Read_Options();

    init();
    OLED_SetFontWidth(6);
    PlotChart();

#if(VirtualDevice)
    usb_init();

    /* ж
       Enable global interrupt */
    EUSB = 1;   //IE2صжλʹܺҪEUSB
    EA = 1;
#else
    HAL_I2C_Init();
    /* ж
       Enable global interrupt */
    EA = 1;
    OLED_Init();
    OLED_Display();
    oled_init_flag = 1;
#endif

    while (1)
    {
#if(VirtualDevice)
        if(DeviceState != DEVSTATE_CONFIGURED)  //ȴUSB
            continue;

        if (bUsbOutReady)
        {
            usb_OUT_done();
        }
#endif
        
        if(oled_init_flag == 0)
            continue;

        P_Ready = 0;

        /* 
           Sampling*/
        GetWaveData();
        
        /* ý
           Enter Settings Interface */
        if (InSettings)
        {
            runWhenInSettrings();
        }

        /* ADCж
           ADC Sampling Interrupt */
        else if (ADCInterrupt)
        {
            runWhenADCInterrupt();
        }

        /* ADC
           ADC Sampling Complete */
        else
        {
            runWhenADCComplete();
        }
    }
}

/* ΪVbatʱ
   Timer for updating Vbat */
void TIMER0_interrupt(void) interrupt TIMER_0
{
    static uint8 n;

    if (++n >= VBAT_UPDATE_FREQ)
    {
        n = 0;
        UpdateVbat = 1;
        DisplayUpdate = 1;
    }
}

void TIMER1_interrupt(void) interrupt 3
{
    KeyScan();

//    if(!PWM1_Flag)
//    {
//        PWM1_Duty++;
//        if(PWM1_Duty >= 8) PWM1_Flag = 1;
//    }
//    else
//    {
//        PWM1_Duty--;
//        if(PWM1_Duty <= 0) PWM1_Flag = 0;
//    }
//    UpdatePwm();
}

//========================================================================
// : void KeyScan(void)
// : ɨ躯
// : none.
// : none.
// 汾: VER1.0
// : 2013-4-1
// ע: 
//========================================================================
void KeyScan(void)
{
	//̰
	if(!KEY1)
	{
		if(!Key1_Flag)
		{
			Key1_cnt++;
			if(Key1_cnt >= 1000)		//1s
			{
				Key1_Short_Flag = 0;	//̰־
//				Key1_Long_Flag = 1;		//ó־
				Key1_Flag = 1;				//ð״ֹ̬ظ
//				Key1_Long_Function = 1;

                /* OLEDʼ */
                if(oled_init_flag == 0)
                {
                    oled_init_flag = 1;
                    OLED_Init();
                    OLED_Display();
                }
                /* 棬лStop/Run״̬ - Switch Run/Stop in main interface    */
                else if (!InSettings)
                {
                    ADCRunning = ~ADCRunning;
                    if (ADCRunning)
                    {
                        WaveUpdate = 1;
                        ClearWave = 1;
                    }
                    else
                    {
                        DisplayUpdate = 1;
                        WaveUpdate = 1;
                    }
                    ADCInterrupt = 1;
                }
            }
			else if(Key1_cnt >= KEY_TIMER)	//30ms
			{
				Key1_Short_Flag = 1;		//ö̰־
			}
		}
	}
	else
	{
		if(Key1_Short_Flag)			//жǷ̰
		{
			Key1_Short_Flag = 0;	//̰־
            Change_Val(1);      /* ת  Clockwise */
        }
		Key1_cnt = 0;
		Key1_Flag = 0;
	}

	//̰
	if(!KEY2)
	{
		if(!Key2_Flag)
		{
			Key2_cnt++;
			if(Key2_cnt >= 1000)		//1s
			{
				Key2_Short_Flag = 0;	//̰־
//				Key2_Long_Flag = 1;		//ó־
				Key2_Flag = 1;				//ð״ֹ̬ظ
//				Key2_Long_Function = 1;

            /* лý - Switch main interface and settings interface */
            InSettings = ~InSettings;

            /*  ý
                Enter Settings  */
            if (InSettings)
            {
                DisplayUpdate = 1;
                UpdateVbat = 1;
                TF0 = 0; //㶨ʱ0־
                TR0 = 1; //ʱ0ʼʱʼصѹϢ¼ʱ
            }

            /*  ص
                Retrurn to main interface   */
            else
            {
                TR0 = 0; //㶨ʱ0־
                TF0 = 0; //ʱ0ֹͣʱֹͣصѹϢ¼ʱ
                WaveFreq = 0;
                TriFail = 0;
                VMax = 0;
                VMin = 0;
                DisplayUpdate = 1;
                WaveUpdate = 1;
                ClearWave = 0;
            }
            ADCInterrupt = 1;
            }
			else if(Key2_cnt >= KEY_TIMER)	//30ms
			{
				Key2_Short_Flag = 1;		//ö̰־
			}
		}
	}
	else
	{
		if(Key2_Short_Flag)			//жǷ̰
		{
			Key2_Short_Flag = 0;	//̰־
            Change_Val(0);          /* ת  Anticlockwise */
        }
		Key2_cnt = 0;
		Key2_Flag = 0;	//ͷ
	}
}
